/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * IntermedPanel.java
 *
 * Created on 15.01.2010, 14:49:17
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.wizard;

import de.umweltcampus.uput.informatik.openeanvadapter.util.FileUtil;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.JTextFieldNotEmptyValidator;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.JTextFieldRegexValidator;
import de.umweltcampus.uput.informatik.openeanvadapter.view.validators.ValidatorChain;
import javax.swing.JOptionPane;

/**
 *
 * @author Timo Johann
 */
public class IntermedPanel extends javax.swing.JPanel implements WizardPanel {

    /** Creates new form IntermedPanel */
    public IntermedPanel() {
        initComponents();
        validtorChain = new ValidatorChain();
        validtorChain.registerValidator(new JTextFieldNotEmptyValidator(tfAdresseIntermediaer, "Addresse Intermediär"));
        validtorChain.registerValidator(new JTextFieldNotEmptyValidator(tfBehoerdlicheNummer, "Behördliche Nummer"));
        validtorChain.registerValidator(new JTextFieldRegexValidator(tfBehoerdlicheNummer, "[ABCDEFGHIKLMNPRSZ](.{8})", "Behördliche Nummer"));


    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlBanner = new javax.swing.JPanel();
        lblProgressImage = new javax.swing.JLabel();
        pnlContent = new javax.swing.JPanel();
        pnlKonfig = new javax.swing.JPanel();
        lblAdresseIntermediaer = new javax.swing.JLabel();
        tfAdresseIntermediaer = new javax.swing.JTextField();
        lblZertifikatIntermediaer = new javax.swing.JLabel();
        btnImportZertifikatIntermediaer = new javax.swing.JButton();
        lblZertifikatServicemodul = new javax.swing.JLabel();
        btnImportZertifikatServicemodul = new javax.swing.JButton();
        lblServiceModulNummer = new javax.swing.JLabel();
        tfBehoerdlicheNummer = new javax.swing.JTextField();
        pnlSonstiges = new javax.swing.JPanel();
        lblAnsprechpartner = new javax.swing.JLabel();
        tfAnsprechpartner = new javax.swing.JTextField();
        lblServiceLink = new javax.swing.JLabel();
        tfServiceLink = new javax.swing.JTextField();

        setLayout(new java.awt.BorderLayout());

        pnlBanner.setLayout(new java.awt.BorderLayout());

        lblProgressImage.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/umweltcampus/uput/informatik/openeanvadapter/resources/adapter_wizard1.PNG"))); // NOI18N
        pnlBanner.add(lblProgressImage, java.awt.BorderLayout.CENTER);

        add(pnlBanner, java.awt.BorderLayout.WEST);

        pnlContent.setLayout(new java.awt.BorderLayout());

        pnlKonfig.setBorder(javax.swing.BorderFactory.createTitledBorder("ZKS Konfiguration"));

        lblAdresseIntermediaer.setText("Adresse des Intermediärs:");

        lblZertifikatIntermediaer.setText("Öffentliches Zertifikat des Intermediärs:");

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("de/umweltcampus/uput/informatik/openeanvadapter/resources/messages"); // NOI18N
        btnImportZertifikatIntermediaer.setText(bundle.getString("Import")); // NOI18N
        btnImportZertifikatIntermediaer.setToolTipText(bundle.getString("ttImportZertifikat")); // NOI18N
        btnImportZertifikatIntermediaer.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnImportZertifikatIntermediaerActionPerformed(evt);
            }
        });

        lblZertifikatServicemodul.setText("Öffentliches Zertifikat des Servicemoduls:");

        btnImportZertifikatServicemodul.setText(bundle.getString("Import")); // NOI18N
        btnImportZertifikatServicemodul.setToolTipText(bundle.getString("ttImportZertifikat")); // NOI18N
        btnImportZertifikatServicemodul.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnImportZertifikatServicemodulActionPerformed(evt);
            }
        });

        lblServiceModulNummer.setText("Behördliche Nummer des Servicemoduls:");

        tfBehoerdlicheNummer.setDocument(new de.umweltcampus.uput.informatik.openeanvadapter.view.documents.RestrictingDocument(9));

        javax.swing.GroupLayout pnlKonfigLayout = new javax.swing.GroupLayout(pnlKonfig);
        pnlKonfig.setLayout(pnlKonfigLayout);
        pnlKonfigLayout.setHorizontalGroup(
            pnlKonfigLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlKonfigLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlKonfigLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(tfAdresseIntermediaer, javax.swing.GroupLayout.DEFAULT_SIZE, 303, Short.MAX_VALUE)
                    .addGroup(pnlKonfigLayout.createSequentialGroup()
                        .addGroup(pnlKonfigLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblAdresseIntermediaer)
                            .addComponent(lblZertifikatIntermediaer))
                        .addContainerGap(111, Short.MAX_VALUE))
                    .addGroup(pnlKonfigLayout.createSequentialGroup()
                        .addComponent(lblServiceModulNummer)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(tfBehoerdlicheNummer, javax.swing.GroupLayout.PREFERRED_SIZE, 94, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())
                    .addGroup(pnlKonfigLayout.createSequentialGroup()
                        .addComponent(lblZertifikatServicemodul)
                        .addContainerGap(104, Short.MAX_VALUE))
                    .addGroup(pnlKonfigLayout.createSequentialGroup()
                        .addComponent(btnImportZertifikatServicemodul)
                        .addContainerGap(214, Short.MAX_VALUE))
                    .addGroup(pnlKonfigLayout.createSequentialGroup()
                        .addComponent(btnImportZertifikatIntermediaer)
                        .addContainerGap(214, Short.MAX_VALUE))))
        );
        pnlKonfigLayout.setVerticalGroup(
            pnlKonfigLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlKonfigLayout.createSequentialGroup()
                .addComponent(lblAdresseIntermediaer)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(tfAdresseIntermediaer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblZertifikatIntermediaer)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(btnImportZertifikatIntermediaer)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlKonfigLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblServiceModulNummer)
                    .addComponent(tfBehoerdlicheNummer, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblZertifikatServicemodul)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(btnImportZertifikatServicemodul)
                .addContainerGap())
        );

        pnlContent.add(pnlKonfig, java.awt.BorderLayout.NORTH);

        pnlSonstiges.setBorder(javax.swing.BorderFactory.createTitledBorder("Sonstiges"));

        lblAnsprechpartner.setText("Ansprechpartner:");

        lblServiceLink.setText("Service-Link:");

        javax.swing.GroupLayout pnlSonstigesLayout = new javax.swing.GroupLayout(pnlSonstiges);
        pnlSonstiges.setLayout(pnlSonstigesLayout);
        pnlSonstigesLayout.setHorizontalGroup(
            pnlSonstigesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlSonstigesLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(pnlSonstigesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblAnsprechpartner)
                    .addComponent(lblServiceLink))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlSonstigesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(tfServiceLink, javax.swing.GroupLayout.DEFAULT_SIZE, 204, Short.MAX_VALUE)
                    .addComponent(tfAnsprechpartner, javax.swing.GroupLayout.DEFAULT_SIZE, 204, Short.MAX_VALUE))
                .addContainerGap())
        );
        pnlSonstigesLayout.setVerticalGroup(
            pnlSonstigesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlSonstigesLayout.createSequentialGroup()
                .addGroup(pnlSonstigesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblAnsprechpartner)
                    .addComponent(tfAnsprechpartner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlSonstigesLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblServiceLink)
                    .addComponent(tfServiceLink, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(192, Short.MAX_VALUE))
        );

        pnlContent.add(pnlSonstiges, java.awt.BorderLayout.CENTER);

        add(pnlContent, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void btnImportZertifikatIntermediaerActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnImportZertifikatIntermediaerActionPerformed
        //Zertifikat importieren
        intermedCert = FileUtil.readFile(this, ".cer", "Zertifikat");
        if (intermedCert != null) {
            JOptionPane.showMessageDialog(this, "Das Zertifikat wurde importiert!", "Info", JOptionPane.INFORMATION_MESSAGE);
        }
}//GEN-LAST:event_btnImportZertifikatIntermediaerActionPerformed

    private void btnImportZertifikatServicemodulActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnImportZertifikatServicemodulActionPerformed
        //Zertifikat importieren
        serviceCert = FileUtil.readFile(this, ".cer", "Zertifikat");
        if (serviceCert != null) {
            JOptionPane.showMessageDialog(this, "Das Zertifikat wurde importiert!", "Info", JOptionPane.INFORMATION_MESSAGE);
        }
}//GEN-LAST:event_btnImportZertifikatServicemodulActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnImportZertifikatIntermediaer;
    private javax.swing.JButton btnImportZertifikatServicemodul;
    private javax.swing.JLabel lblAdresseIntermediaer;
    private javax.swing.JLabel lblAnsprechpartner;
    private javax.swing.JLabel lblProgressImage;
    private javax.swing.JLabel lblServiceLink;
    private javax.swing.JLabel lblServiceModulNummer;
    private javax.swing.JLabel lblZertifikatIntermediaer;
    private javax.swing.JLabel lblZertifikatServicemodul;
    private javax.swing.JPanel pnlBanner;
    private javax.swing.JPanel pnlContent;
    private javax.swing.JPanel pnlKonfig;
    private javax.swing.JPanel pnlSonstiges;
    private javax.swing.JTextField tfAdresseIntermediaer;
    private javax.swing.JTextField tfAnsprechpartner;
    private javax.swing.JTextField tfBehoerdlicheNummer;
    private javax.swing.JTextField tfServiceLink;
    // End of variables declaration//GEN-END:variables
    private ValidatorChain validtorChain;
    private byte[] intermedCert;
    private byte[] serviceCert;

    @Override
    public void handleData(WizardDataContainer container) {
        container.setIntermedAdresse(tfAdresseIntermediaer.getText());
        container.setIntermedCert(new byte[3]);
        container.setServiceModulNummer(tfBehoerdlicheNummer.getText());
        container.setServiceModulCert(new byte[3]);
        container.setServiceLink(tfServiceLink.getText());
        container.setAnsprechPartner(tfAnsprechpartner.getText());
        container.setIntermedCert(intermedCert);
        container.setServiceModulCert(serviceCert);
    }

    @Override
    public boolean isWizardPanelValid() {

        boolean isValidated = validtorChain.runValidation();

        if ((intermedCert == null || serviceCert == null) && isValidated) {
            if (JOptionPane.showConfirmDialog(this, "Es wurden nicht alle Zertifikate der ZKS ausgewählt, diese werden für die Kommunikation mit der ZKS benötigt. Trotzdem fortsetzen?", "Bestätigen", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION) {
                return true;
            } else {
                return false;
            }
        }
        return isValidated;
    }
}
