/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * SummaryPanel.java
 *
 * Created on 15.01.2010, 15:39:40
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.wizard;

import java.awt.Color;

/**
 *
 * @author Timo Johann
 */
public class SummaryPanel extends javax.swing.JPanel implements WizardPanel {

    /** Creates new form SummaryPanel */
    public SummaryPanel() {
        initComponents();
        System.out.println("initData");
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlBanner = new javax.swing.JPanel();
        lblProgressImage = new javax.swing.JLabel();
        pnlContent = new javax.swing.JPanel();
        pnlIntermed = new javax.swing.JPanel();
        lblIntermed1 = new javax.swing.JLabel();
        lblIntermedAdresse = new javax.swing.JLabel();
        lblIntermed3 = new javax.swing.JLabel();
        lblIntermedZert = new javax.swing.JLabel();
        lblIntermed5 = new javax.swing.JLabel();
        lblIntermedVerbindung = new javax.swing.JLabel();
        btnTestConnection = new javax.swing.JButton();
        pnlUnternehmen = new javax.swing.JPanel();
        lblUnternehmen = new javax.swing.JLabel();
        lblUnternehmenName = new javax.swing.JLabel();
        lblUnternehmen2 = new javax.swing.JLabel();
        lblUnternehmenNummer = new javax.swing.JLabel();
        lblUnternehmen4 = new javax.swing.JLabel();
        lblUnternehmenPlz = new javax.swing.JLabel();
        lblUnternehmen6 = new javax.swing.JLabel();
        lblUnternehmenOrt = new javax.swing.JLabel();
        lblUnternehmen8 = new javax.swing.JLabel();
        lblUnternehmenRolle = new javax.swing.JLabel();
        lblUnternehmen10 = new javax.swing.JLabel();
        lblUnternehmenZert = new javax.swing.JLabel();
        pblServicemodul = new javax.swing.JPanel();
        lblService1 = new javax.swing.JLabel();
        lblServiceNummer = new javax.swing.JLabel();
        lblService2 = new javax.swing.JLabel();
        lblServiceZert = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        pnlBanner.setLayout(new java.awt.BorderLayout());

        lblProgressImage.setIcon(new javax.swing.ImageIcon(getClass().getResource("/de/umweltcampus/uput/informatik/openeanvadapter/resources/adapter_wizard3.PNG"))); // NOI18N
        pnlBanner.add(lblProgressImage, java.awt.BorderLayout.CENTER);

        add(pnlBanner, java.awt.BorderLayout.WEST);

        pnlContent.setLayout(new java.awt.BorderLayout());

        pnlIntermed.setBorder(javax.swing.BorderFactory.createTitledBorder("Intermediär"));

        lblIntermed1.setText("Intermediär Adresse");

        lblIntermedAdresse.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblIntermedAdresse.setText("jLabel2");

        lblIntermed3.setLabelFor(lblIntermedZert);
        lblIntermed3.setText("Öffentliches Zertifikat");

        lblIntermedZert.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblIntermedZert.setText("jLabel2");

        lblIntermed5.setLabelFor(lblIntermedZert);
        lblIntermed5.setText("Verbindung");

        lblIntermedVerbindung.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblIntermedVerbindung.setText("jLabel2");

        btnTestConnection.setText("Verbindungstest");
        btnTestConnection.setEnabled(false);

        javax.swing.GroupLayout pnlIntermedLayout = new javax.swing.GroupLayout(pnlIntermed);
        pnlIntermed.setLayout(pnlIntermedLayout);
        pnlIntermedLayout.setHorizontalGroup(
            pnlIntermedLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlIntermedLayout.createSequentialGroup()
                .addComponent(lblIntermed1, javax.swing.GroupLayout.PREFERRED_SIZE, 175, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblIntermedAdresse, javax.swing.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE))
            .addGroup(pnlIntermedLayout.createSequentialGroup()
                .addComponent(lblIntermed3, javax.swing.GroupLayout.PREFERRED_SIZE, 175, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblIntermedZert, javax.swing.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE))
            .addGroup(pnlIntermedLayout.createSequentialGroup()
                .addComponent(lblIntermed5, javax.swing.GroupLayout.PREFERRED_SIZE, 175, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblIntermedVerbindung, javax.swing.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE))
            .addComponent(btnTestConnection, javax.swing.GroupLayout.PREFERRED_SIZE, 175, javax.swing.GroupLayout.PREFERRED_SIZE)
        );
        pnlIntermedLayout.setVerticalGroup(
            pnlIntermedLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlIntermedLayout.createSequentialGroup()
                .addGroup(pnlIntermedLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblIntermed1, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblIntermedAdresse, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlIntermedLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblIntermedZert, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(lblIntermed3, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlIntermedLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(pnlIntermedLayout.createSequentialGroup()
                        .addComponent(lblIntermed5, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(btnTestConnection))
                    .addComponent(lblIntermedVerbindung, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );

        pnlContent.add(pnlIntermed, java.awt.BorderLayout.CENTER);

        pnlUnternehmen.setBorder(javax.swing.BorderFactory.createTitledBorder("Unternehmen"));

        lblUnternehmen.setText("Name");

        lblUnternehmenName.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblUnternehmenName.setText("hj");

        lblUnternehmen2.setText("Behördliche Nummer");

        lblUnternehmenNummer.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblUnternehmenNummer.setText("dhgj");

        lblUnternehmen4.setText("Postleitzahl");

        lblUnternehmenPlz.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblUnternehmenPlz.setText("djfdj");

        lblUnternehmen6.setText("Ort");

        lblUnternehmenOrt.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblUnternehmenOrt.setText("Name");

        lblUnternehmen8.setText("Rolle");

        lblUnternehmenRolle.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblUnternehmenRolle.setText("Name");

        lblUnternehmen10.setText("Zertifikat");

        lblUnternehmenZert.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblUnternehmenZert.setText("Name");

        javax.swing.GroupLayout pnlUnternehmenLayout = new javax.swing.GroupLayout(pnlUnternehmen);
        pnlUnternehmen.setLayout(pnlUnternehmenLayout);
        pnlUnternehmenLayout.setHorizontalGroup(
            pnlUnternehmenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlUnternehmenLayout.createSequentialGroup()
                .addComponent(lblUnternehmen, javax.swing.GroupLayout.PREFERRED_SIZE, 175, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblUnternehmenName, javax.swing.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE))
            .addGroup(pnlUnternehmenLayout.createSequentialGroup()
                .addComponent(lblUnternehmen2, javax.swing.GroupLayout.PREFERRED_SIZE, 175, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblUnternehmenNummer, javax.swing.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE))
            .addGroup(pnlUnternehmenLayout.createSequentialGroup()
                .addComponent(lblUnternehmen4, javax.swing.GroupLayout.PREFERRED_SIZE, 175, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblUnternehmenPlz, javax.swing.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE))
            .addGroup(pnlUnternehmenLayout.createSequentialGroup()
                .addComponent(lblUnternehmen6, javax.swing.GroupLayout.PREFERRED_SIZE, 175, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblUnternehmenOrt, javax.swing.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE))
            .addGroup(pnlUnternehmenLayout.createSequentialGroup()
                .addComponent(lblUnternehmen8, javax.swing.GroupLayout.PREFERRED_SIZE, 175, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblUnternehmenRolle, javax.swing.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE))
            .addGroup(pnlUnternehmenLayout.createSequentialGroup()
                .addComponent(lblUnternehmen10, javax.swing.GroupLayout.PREFERRED_SIZE, 175, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblUnternehmenZert, javax.swing.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE))
        );
        pnlUnternehmenLayout.setVerticalGroup(
            pnlUnternehmenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pnlUnternehmenLayout.createSequentialGroup()
                .addGroup(pnlUnternehmenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblUnternehmen)
                    .addComponent(lblUnternehmenName))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlUnternehmenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblUnternehmen2)
                    .addComponent(lblUnternehmenNummer))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlUnternehmenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblUnternehmenPlz)
                    .addComponent(lblUnternehmen4))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlUnternehmenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblUnternehmenOrt)
                    .addComponent(lblUnternehmen6))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlUnternehmenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblUnternehmen8)
                    .addComponent(lblUnternehmenRolle))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pnlUnternehmenLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblUnternehmen10)
                    .addComponent(lblUnternehmenZert))
                .addContainerGap())
        );

        pnlContent.add(pnlUnternehmen, java.awt.BorderLayout.NORTH);

        pblServicemodul.setBorder(javax.swing.BorderFactory.createTitledBorder("Servicemodul"));

        lblService1.setText("Behördliche Nummer");

        lblServiceNummer.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblServiceNummer.setText("jLabel1");

        lblService2.setText("Öffentliches Zertifikat");

        lblServiceZert.setFont(new java.awt.Font("Tahoma", 1, 11));
        lblServiceZert.setText("jLabel1");

        javax.swing.GroupLayout pblServicemodulLayout = new javax.swing.GroupLayout(pblServicemodul);
        pblServicemodul.setLayout(pblServicemodulLayout);
        pblServicemodulLayout.setHorizontalGroup(
            pblServicemodulLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pblServicemodulLayout.createSequentialGroup()
                .addComponent(lblService1, javax.swing.GroupLayout.PREFERRED_SIZE, 175, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblServiceNummer, javax.swing.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE))
            .addGroup(pblServicemodulLayout.createSequentialGroup()
                .addComponent(lblService2, javax.swing.GroupLayout.PREFERRED_SIZE, 175, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblServiceZert, javax.swing.GroupLayout.DEFAULT_SIZE, 286, Short.MAX_VALUE))
        );
        pblServicemodulLayout.setVerticalGroup(
            pblServicemodulLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(pblServicemodulLayout.createSequentialGroup()
                .addGroup(pblServicemodulLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblService1)
                    .addComponent(lblServiceNummer))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(pblServicemodulLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblServiceZert)
                    .addComponent(lblService2))
                .addContainerGap())
        );

        pnlContent.add(pblServicemodul, java.awt.BorderLayout.SOUTH);

        add(pnlContent, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnTestConnection;
    private javax.swing.JLabel lblIntermed1;
    private javax.swing.JLabel lblIntermed3;
    private javax.swing.JLabel lblIntermed5;
    private javax.swing.JLabel lblIntermedAdresse;
    private javax.swing.JLabel lblIntermedVerbindung;
    private javax.swing.JLabel lblIntermedZert;
    private javax.swing.JLabel lblProgressImage;
    private javax.swing.JLabel lblService1;
    private javax.swing.JLabel lblService2;
    private javax.swing.JLabel lblServiceNummer;
    private javax.swing.JLabel lblServiceZert;
    private javax.swing.JLabel lblUnternehmen;
    private javax.swing.JLabel lblUnternehmen10;
    private javax.swing.JLabel lblUnternehmen2;
    private javax.swing.JLabel lblUnternehmen4;
    private javax.swing.JLabel lblUnternehmen6;
    private javax.swing.JLabel lblUnternehmen8;
    private javax.swing.JLabel lblUnternehmenName;
    private javax.swing.JLabel lblUnternehmenNummer;
    private javax.swing.JLabel lblUnternehmenOrt;
    private javax.swing.JLabel lblUnternehmenPlz;
    private javax.swing.JLabel lblUnternehmenRolle;
    private javax.swing.JLabel lblUnternehmenZert;
    private javax.swing.JPanel pblServicemodul;
    private javax.swing.JPanel pnlBanner;
    private javax.swing.JPanel pnlContent;
    private javax.swing.JPanel pnlIntermed;
    private javax.swing.JPanel pnlUnternehmen;
    // End of variables declaration//GEN-END:variables

    @Override
    public void handleData(WizardDataContainer container) {

        lblIntermedAdresse.setText(container.getIntermedAdresse());
        //TODO: Verbindung wirklich prüfen
        lblIntermedVerbindung.setText("Ok");
        //TODO: Ein weniger steschendes Grün verwenden, das ist ja schrecklich
        lblIntermedVerbindung.setForeground(Color.GREEN);
        if (container.getIntermedCert() == null) {
            lblIntermedZert.setText("nicht vorhanden");
            lblIntermedZert.setForeground(Color.RED);
        } else {
            lblIntermedZert.setText("vorhanden");
            lblIntermedZert.setForeground(Color.GREEN);
        }

        lblServiceNummer.setText(container.getServiceModulNummer());
        if (container.getServiceModulCert() == null) {
            lblServiceZert.setText("nicht vorhanden");
            lblServiceZert.setForeground(Color.RED);

        } else {
            lblServiceZert.setText("vorhanden");
            lblServiceZert.setForeground(Color.GREEN);

        }

        lblUnternehmenName.setText(container.getName());
        lblUnternehmenNummer.setText(container.getBehoerdlichNummer());
        lblUnternehmenOrt.setText(container.getOrt());
        lblUnternehmenPlz.setText(String.valueOf(container.getPlz()));
        lblUnternehmenRolle.setText(container.getRolle().name());

        lblUnternehmenZert.setForeground(Color.GREEN);
        StringBuilder cert = new StringBuilder();
        if (container.getPrivateCert() != null) {
            cert.append("privat: vorhanden");
        } else {
            cert.append("privat: nicht vorhanden");
            lblUnternehmenZert.setForeground(Color.RED);
        }
        if (container.getPublicCert() != null) {
            cert.append(", public: vorhanden");
        } else {
            cert.append(", public: nicht vorhanden");
            lblUnternehmenZert.setForeground(Color.RED);
        }
        lblUnternehmenZert.setText(cert.toString());



    }

    @Override
    public boolean isWizardPanelValid() {
        return true;
    }
}
