/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.wizard;

import java.awt.CardLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;

/**
 *
 * @author Marc Beck
 */
public class WizardController {

    private WizardDataContainer dataContainer;
    private final WizardPanel[] panels;
    private final String[] panelNames;
    private String summaryPanelName = "Summary";
    private int activePanelIndex = 0;
    private final JButton nextButton;
    private final JButton prevButton;
    private final JButton finishButton;
    private final JPanel contentPanel;

    private enum COMMAND {

        NEXT, PREV,
        FINISH;
    };

    /**
     * WizardController für SwingKomponenten
     * @param nextButton der Next-Button
     * @param prevButton der Prev-Button
     * @param finishButton der Finish-Button
     * @param contentPanel das Panel, das die anzuzeigenden Panels beinhaltet.<br>
     * Das contentPanel MUSS CardLayout als Manager haben.
     */
    public WizardController(JButton nextButton, JButton prevButton, JButton finishButton, JPanel contentPanel, WizardPanel[] panels, String[] panelNames) {
        this.panelNames = panelNames;
        this.nextButton = nextButton;
        this.prevButton = prevButton;
        this.finishButton = finishButton;
        this.contentPanel = contentPanel;
        this.panels = panels;
        this.dataContainer = new WizardDataContainer();
        nextButton.addActionListener(new WizardListener(COMMAND.NEXT));
        prevButton.addActionListener(new WizardListener(COMMAND.PREV));
        finishButton.addActionListener(new WizardListener(COMMAND.FINISH));
        checkCommandsEnabled();
    }

    /**
     * Gibt abhängig vom verwendeten Kommando das passende Panel zurück.
     * @param command
     * @return
     */
    private String getPanelToView(final COMMAND command) {

        switch (command) {
            case NEXT:

                if (activePanelIndex + 1 < panelNames.length) {

                    System.out.println(panelNames[activePanelIndex]);
                    panels[activePanelIndex].handleData(dataContainer);

                    activePanelIndex++;
                    if (activePanelIndex + 1 == panelNames.length) {
                        panels[panelNames.length - 1].handleData(dataContainer);
                    }
                    return panelNames[activePanelIndex];
                }


            case PREV:

                if (activePanelIndex - 1 >= 0 && activePanelIndex - 1 < panelNames.length) {
                    activePanelIndex--;
                    return panelNames[activePanelIndex];
                } else if (activePanelIndex > panelNames.length) {
                    activePanelIndex = panelNames.length - 1;
                    return panelNames[activePanelIndex];
                }

            case FINISH:
                activePanelIndex = Integer.MAX_VALUE - 1;
                WizardFinisher.finish(dataContainer);
                return summaryPanelName;
        }
        return panelNames[activePanelIndex];

    }

    /**
     * Prüft, ob die Buttons enabled sein dürfen, oder nicht und setzt die jeweilig Eigenschaft.
     */
    private void checkCommandsEnabled() {
        if (activePanelIndex + 1 >= panelNames.length) {
            nextButton.setEnabled(false);
            finishButton.setEnabled(true);
        } else {
            nextButton.setEnabled(true);
            finishButton.setEnabled(false);
        }
        if (activePanelIndex - 1 < 0 || activePanelIndex - 1 >= panelNames.length) {
            prevButton.setEnabled(false);
        } else {
            prevButton.setEnabled(true);
        }
    }

    /**
     * Interner ActionListener für die im WizardController registrierten Buttons.<br>
     */
    class WizardListener implements ActionListener {

        private final COMMAND command;

        public WizardListener(COMMAND command) {
            this.command = command;
        }

        /**
         * Zeigt das jeweils passende Panel innerhalb des contenPanel an.
         * @param e
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            if (panels[activePanelIndex].isWizardPanelValid()) {
                String panelToView = getPanelToView(command);
                CardLayout cardLayout = (CardLayout) contentPanel.getLayout();
                cardLayout.show(contentPanel, panelToView);
                checkCommandsEnabled();
            }
        }
    }

    public WizardDataContainer getDataContainer() {
        return dataContainer;
    }
}
