/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.wizard;

import de.umweltcampus.uput.informatik.openeanvadapter.data.dao.CompanyDAO;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Certificate;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Company;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.RoleType;
import de.umweltcampus.uput.informatik.openeanvadapter.data.model.ZKSConfiguration;
import de.umweltcampus.uput.informatik.openeanvadapter.util.GenericUtils;
import java.util.Date;

/**
 *
 * @author Timo Johann
 */
public class WizardFinisher {

    static void finish(WizardDataContainer container) {

        //Unternehmen übernehmen
        Company company = new Company();
        company.setName(container.getName());

        Address address = new Address();
        address.setRegisterNumber(container.getBehoerdlichNummer());
        address.setName1(container.getName());
        address.setCity(container.getOrt());
        address.setPostalCode(String.valueOf(container.getPlz()));
        RoleType rolle = container.getRolle();
        address.setRoleType(rolle);
        address.setOsciTimestamp(GenericUtils.getISO8601Timestamp(new Date()));
        address.setPublicCertificate(new Certificate());
        address.getPublicCertificate().setCertificate(container.getPublicCert());
        address.setPrivateCertificate(new Certificate());
        address.getPrivateCertificate().setCertificate(container.getPrivateCert());
        address.getPrivateCertificate().setPassword(new String(container.getCertPassword()));

        company.setDefaultAddress(address);
        company.getAddresses().add(address);

        //ZKSKonfiguration übernehmen
        ZKSConfiguration configuration = new ZKSConfiguration();
        configuration.setAddressIntermed(container.getIntermedAdresse());
        configuration.setRegisterNumber(container.getServiceModulNummer());
        configuration.setContactPerson(container.getAnsprechPartner());
        configuration.setServiceLink(container.getServiceLink());
        configuration.setCertificateIntermed(new Certificate());
        configuration.getCertificateIntermed().setCertificate(container.getIntermedCert());
        configuration.setCertificateServicemodul(new Certificate());
        configuration.getCertificateServicemodul().setCertificate(container.getServiceModulCert());
        company.setzKSConfig(configuration);

        CompanyDAO cdao = new CompanyDAO();
        cdao.create(company);
    }
}
