/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MainPanel.java
 *
 * Created on 27.10.2009, 08:44:00
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.components.wizard;

import de.umweltcampus.uput.informatik.openeanvadapter.resources.MessageBundle;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.MenuFrame;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

/**
 *
 * @author Marc Beck
 */
public class WizardMainPanel extends javax.swing.JPanel {

    private WizardPanel welcomePanel;
    private WizardPanel intermedPanel;
    private WizardPanel companyPanel;
    private WizardPanel summaryPanel;

    /** Creates new form MainPanel */
    public WizardMainPanel() {
        welcomePanel = new WelcomePanel();
        intermedPanel = new IntermedPanel();
        companyPanel = new CompanyPanel();
        summaryPanel = new SummaryPanel();

        initComponents();
        WizardDataContainer container = new WizardDataContainer();
        String[] panelNames = {"Welcome", "Intermed", "Unternehmen", "Summary"};
        WizardPanel[] panels = {welcomePanel, intermedPanel, companyPanel, summaryPanel};
        WizardController wizardController = new WizardController(btnNext, btnBack, btnFinish, pnlContent, panels, panelNames);

    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        pnlButtons = new javax.swing.JPanel();
        btnBack = new javax.swing.JButton();
        btnNext = new javax.swing.JButton();
        btnFinish = new javax.swing.JButton();
        pnlContent = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        pnlButtons.setLayout(new java.awt.GridLayout(1, 0));

        btnBack.setMnemonic('z');
        btnBack.setText("Zurück");
        pnlButtons.add(btnBack);

        btnNext.setMnemonic('w');
        btnNext.setText("Weiter");
        pnlButtons.add(btnNext);

        btnFinish.setMnemonic('f');
        btnFinish.setText("Fertig stellen");
        btnFinish.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnFinishActionPerformed(evt);
            }
        });
        pnlButtons.add(btnFinish);

        add(pnlButtons, java.awt.BorderLayout.SOUTH);

        pnlContent.setLayout(new java.awt.CardLayout());
        add(pnlContent, java.awt.BorderLayout.CENTER);
        pnlContent.add((Component)welcomePanel     , "Welcome");
        pnlContent.add((Component)intermedPanel    , "Intermed");
        pnlContent.add((Component)companyPanel , "Unternehmen");
        pnlContent.add((Component)summaryPanel     , "Summary");
    }// </editor-fold>//GEN-END:initComponents

    private void btnFinishActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnFinishActionPerformed

        ImageIcon icon = new ImageIcon(WizardMainPanel.class.getResource("/de/umweltcampus/uput/informatik/openeanvadapter/resources/icon.png"));

        btnBack.setEnabled(false);
        btnFinish.setEnabled(false);
        JOptionPane.showMessageDialog(this, "Daten wurden angelegt!", "Info", JOptionPane.INFORMATION_MESSAGE);
        JFrame frame = new MenuFrame();
        frame.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        frame.setTitle(MessageBundle.getString("ApplicationName") + " " + MessageBundle.getString("Version"));
        frame.setIconImage(icon.getImage());
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }//GEN-LAST:event_btnFinishActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnBack;
    private javax.swing.JButton btnFinish;
    private javax.swing.JButton btnNext;
    private javax.swing.JPanel pnlButtons;
    private javax.swing.JPanel pnlContent;
    // End of variables declaration//GEN-END:variables
}
