/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.listeners;

import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Message;
import de.umweltcampus.uput.informatik.openeanvadapter.view.components.messageservice.OSCIMessageListPanel;
import de.umweltcampus.uput.informatik.openeanvadapter.view.models.MessageTableModel;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTable;

/**
 * DetailPopUpListener für die Nachrichtentabellen
 * @author Marc Beck
 */
public class DetailPopupListener extends MouseAdapter implements KeyListener {

    private JTable table;

    public DetailPopupListener(JTable table) {
        this.table = table;
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            //Selektieren
            table.setRowSelectionInterval(table.rowAtPoint(e.getPoint()), table.rowAtPoint(e.getPoint()));
            table.setColumnSelectionInterval(table.columnAtPoint(e.getPoint()), table.columnAtPoint(e.getPoint()));
            //Details anzeigen
            showDetailDialog();
        }
    }

    /**
     * Zeigt die Details als PopUp an.
     * @param e
     */
    private void showDetailDialog() {
        int index = table.getSelectedRow();
        if (index != -1) {
            index = table.getRowSorter().convertRowIndexToModel(index);
            JPopupMenu jPopupMenu = new JPopupMenu();
            if (table.getModel() instanceof MessageTableModel) {
                MessageTableModel entm = (MessageTableModel) table.getModel();
                Message message = entm.getMessageAt(index);
                jPopupMenu.add(new OSCIMessageListPanel(message.getOsciMessages()));
            }
            Rectangle r = table.getCellRect(table.getRowSorter().convertRowIndexToView(index), table.getSelectedColumn(), false);
            jPopupMenu.show(table, r.x, r.y);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        //nix machen
    }

    @Override
    public void keyPressed(KeyEvent e) {
        //Den Kontext Menü Button abfragen
        if (e.getKeyCode() == KeyEvent.VK_CONTEXT_MENU) {
            showDetailDialog();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        //nix machen
    }
}
