/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.models;

import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Address;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/**
 *
 * @author Marc Beck
 */
public class AddressTableModel extends AbstractTableModel {

    private static final String[] colHeaders = {"Name", "Ort", "Rolle", "Behördliche Nummer"};
    private static final Class[] colDataTypes = {String.class, String.class, String.class, String.class};
    //Indizes
    private static final int COL_NAME = 0;
    private static final int COL_ORT = 1;
    private static final int COL_ROLLE = 2;
    private static final int COL_NUMMER = 3;
    //Daten
    List<Address> data;

    /**
     * Konstruktor
     * @param addresses
     */
    public AddressTableModel(List<Address> addresses) {
        this.data = addresses;
        if (data == null) {
            data = new ArrayList<Address>();
        }
    }

    @Override
    public int getColumnCount() {
        return colHeaders.length;
    }

    @Override
    public int getRowCount() {
        return data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Address address = data.get(rowIndex);
        switch (columnIndex) {
            case COL_NAME:
                return address.getName1();
            case COL_ORT:
                return address.getCity();
            case COL_ROLLE:
                return address.getRoleType().name();
            case COL_NUMMER:
                return address.getRegisterNumber();
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return colHeaders[columnIndex];
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        return colDataTypes[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Address getAddressAt(int rowIndex) {
        Address address = data.get(rowIndex);
        return address;
    }
}
