/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.models;


import de.umweltcampus.uput.informatik.openeanvadapter.communication.osci.MessageHeaderContainer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;

/**
 * TableModel for MessageHeaderContainer
 * @author Marc Beck
 */
public class MessageHeaderContainerTableModel extends AbstractTableModel {

    private static final String[] colHeaders = {"Betreff", "Im Postfach seit", "Abgeholt am"};
    private static final Class[] colDataTypes = {String.class, Date.class, Date.class};
    //Indizes
    private static final int COL_BETREFF = 0;
    private static final int COL_POSTFACH_DATUM = 1;
    private static final int COL_ABHOL_DATUM = 2;
    //Daten
    private List<MessageHeaderContainer> data;

    /**
     * Konstruktor
     * @param container 
     */
    public MessageHeaderContainerTableModel(List<MessageHeaderContainer> container) {
        this.data = container;
        if (data == null) {
            data = new ArrayList<MessageHeaderContainer>();
        }
    }

    @Override
    public int getColumnCount() {
        return colHeaders.length;
    }

    @Override
    public int getRowCount() {
        return data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MessageHeaderContainer container = data.get(rowIndex);
        switch (columnIndex) {
            case COL_BETREFF:
                return container.getBetreff();
            case COL_POSTFACH_DATUM:
                return container.getErstellung();
            case COL_ABHOL_DATUM:
                return container.getEmpfang();
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return colHeaders[columnIndex];
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        return colDataTypes[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public MessageHeaderContainer getContainerAt(int rowIndex) {
        MessageHeaderContainer container = data.get(rowIndex);
        return container;
    }
}
