/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.models;

import de.umweltcampus.uput.informatik.openeanvadapter.data.model.Message;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 *
 * @author Marc
 */
public class ReceivedMessagesTableModel extends MessageTableModel {

    private static final String[] colHeaders = {"ID", "Datum", "Typ", "Empfänger"};
    private static final Class[] colDataTypes = {Long.class, Date.class, String.class, String.class};
    //Indizes
    private static final int COL_ID = 0;
    private static final int COL_DATUM = 1;
    private static final int COL_TYP = 2;
    private static final int COL_RECEIVER = 3;
    //Daten
    List<Message> data;

    /**
     * Konstruktor
     * @param adressen
     */
    public ReceivedMessagesTableModel(List<Message> message) {
        this.data = message;
        if (data == null) {
            data = new ArrayList<Message>();
        }
    }

    @Override
    public int getColumnCount() {
        return colHeaders.length;
    }

    @Override
    public int getRowCount() {
        return data.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Message message = data.get(rowIndex);
        switch (columnIndex) {
            case COL_ID:
                return message.getId();
            case COL_DATUM:
                return message.getListedSince();
            case COL_TYP:
                return message.getType();
            case COL_RECEIVER:
                if (message.getReceiver() != null) {
                    return message.getReceiver().getName1();
                } else {
                    return "unbekannt";
                }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return colHeaders[columnIndex];
    }

    @Override
    public Class getColumnClass(int columnIndex) {
        return colDataTypes[columnIndex];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public Message getMessageAt(int rowIndex) {
        Message message = data.get(rowIndex);
        return message;
    }
}
