/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.validators;

import java.awt.Color;
import javax.swing.JPasswordField;

/**
 * Validator zum überprüfen, ob ein Passwort-Feld, den selben Text wie ein anderes
 * Passwort-Feld hat.
 * @author Marc Beck
 */
public class JPasswordFieldConfirmationValidator implements SwingValidator {

    private final JPasswordField field1;
    private final Color field1Color;
    private final JPasswordField field2;
    private final Color field2Color;

    public JPasswordFieldConfirmationValidator(JPasswordField field1, JPasswordField field2) {
        this.field1 = field1;
        this.field1Color = field1.getBackground();
        this.field2 = field2;
        this.field2Color = field2.getBackground();
    }

    @Override
    public boolean isValid() {
        String s1 = new String(field1.getPassword());
        String s2 = new String(field2.getPassword());
        if (!s1.equals(s2)) {
            field1.setBackground(new Color(255, 204, 204));
            field2.setBackground(new Color(255, 204, 204));
            return false;
        }
        return true;
    }

    @Override
    public String getMessage() {
        return "Passwort stimmt nicht überein!";
    }

    @Override
    public void reset() {
        field1.setBackground(field1Color);
        field2.setBackground(field2Color);
    }
}
