/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.validators;

import java.awt.Color;
import javax.swing.JTextField;

/**
 * Validator der die Eingabe auf Integer-Werte überprüft
 * @author Marc Beck
 */
public class JTextFieldIntegerValidator implements SwingValidator {

    private final JTextField jTextField;
    private final Color defaultBgColor;
    private final String fieldName;

    public JTextFieldIntegerValidator(JTextField jTextField, String fieldName) {
        this.jTextField = jTextField;
        this.defaultBgColor = jTextField.getBackground();
        this.fieldName = fieldName;
    }

    @Override
    public boolean isValid() {
        String s = jTextField.getText();
        try {
            Integer.parseInt(s);
        } catch (NumberFormatException e) {
            jTextField.setBackground(new Color(255, 204, 204));
            return false;
        }
        return true;
    }

    @Override
    public String getMessage() {
        return fieldName + ": Eingabe muss eine Ganzzahl sein!";
    }

    @Override
    public void reset() {
        jTextField.setBackground(defaultBgColor);
    }
}
