/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.validators;

import java.awt.Color;
import java.util.regex.Pattern;
import javax.swing.JTextField;

/**
 * Validator der die Eingabe eines JTextFieldes gegen einen
 * regulären Ausdruck überprüft.
 * <br>
 * Die Eingabe kann aber auch leer sein.
 * @author Marc Beck
 */
public class JTextFieldRegexValidator implements SwingValidator {

    private final JTextField jTextField;
    private final Pattern pattern;
    private final Color defaultBgColor;
    private final String fieldName;

    /**
     * Konstruktor
     * @param jTextField das zu prüfende JTextField
     * @param pattern das Pattern, gegen das geprüft werden soll
     * @param fieldName der Feldname, der in der Validierungsnachricht angezeigt werden soll
     */
    public JTextFieldRegexValidator(JTextField jTextField, String pattern, String fieldName) {
        this.jTextField = jTextField;
        this.pattern = Pattern.compile(pattern);
        this.defaultBgColor = jTextField.getBackground();
        this.fieldName = fieldName;
    }

    @Override
    public boolean isValid() {
        //darf leer sein
        if ("".equals(jTextField.getText())) {
            return true;
        }
        boolean b = pattern.matcher(jTextField.getText()).matches();
        if (!b) {
            jTextField.setBackground(new Color(255, 204, 204));
        }
        return b;
    }

    @Override
    public String getMessage() {
        return fieldName + ": Eingabe entspricht nicht dem Muster: " + pattern;
    }

    @Override
    public void reset() {
        jTextField.setBackground(defaultBgColor);
    }
}
