/**
 * Copyright 2010 FH Trier, Umwelt-Campus Birkenfeld
 * 
 * FH Trier, Umwelt-Campus Birkenfeld  
 * P.O. Box 1380
 * D-55761 Birkenfeld
 * GERMANY
 *
 * http://www.umwelt-campus.de
 *
 * Lizenziert unter der EUPL, Version 1.1 oder - sobald
 * diese von der Europäischen Kommission genehmigt wurden -
 * Folgeversionen der EUPL ("Lizenz");
 * Sie dürfen dieses Werk ausschließlich gemäß dieser Lizenz nutzen.
 * Eine Kopie der Lizenz finden Sie hier:
 *
 * http://ec.europa.eu/idabc/eupl
 *
 * Sofern nicht durch anwendbare Rechtsvorschriften
 * gefordert oder in schriftlicher Form vereinbart, wird
 * die unter der Lizenz verbreitete Software "so wie sie ist",
 * OHNE JEGLICHE GEWÄHRLEISTUNG ODER BEDINGUNGEN -
 * ausdrücklich oder stillschweigend - verbreitet.
 * Die sprachspezifischen Genehmigungen und Beschränkungen
 * unter der Lizenz sind dem Lizenztext zu entnehmen.
 */
 
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package de.umweltcampus.uput.informatik.openeanvadapter.view.validators;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

/**
 * Klasse die alle SwingValidatoren in einer Liste aufnimmt.
 * <br>
 * Dient der Validierung von Formularen
 * @author Marc Beck
 */
public class ValidatorChain {

    private List<SwingValidator> validators;
    private List<String> messages;

    /**
     * Konstruktor
     */
    public ValidatorChain() {
        this.validators = new ArrayList<SwingValidator>();
    }

    /**
     * Registriert einen SwingValidator in dieser ValidatorChain
     * @param swingValidator
     */
    public void registerValidator(SwingValidator swingValidator) {
        validators.add(swingValidator);
    }

    /**
     * Lässt die Validierung durchlaufen.
     * @return
     */
    public boolean runValidation() {
        boolean valid = true;
        this.messages = new ArrayList<String>();
        //Validatoren zurück setzen
        for (SwingValidator validator : validators) {
            validator.reset();
        }
        //Prüfungen anstossen
        for (SwingValidator validator : validators) {
            boolean b = validator.isValid();
            if (!b) {
                valid = false;
                messages.add(validator.getMessage());
            }
        }
        return valid;
    }

    /**
     * Zeigt einen JDialog an, der die gesammelten Validierungsnachrichten enthält<br>
     * Vor Aufruf dieser Funktion muss runValidation() ausgeführt worden sein.
     * @param parent
     */
    public void viewValidationReport(Component parent) {
        StringBuilder sb = new StringBuilder();
        for (String message : messages) {
            sb.append(message);
            sb.append("\n");
        }
        JOptionPane.showMessageDialog(parent, sb.toString(), "Eingabefehler", JOptionPane.ERROR_MESSAGE);
    }
}
